@php use Illuminate\Support\Str; @endphp
    <!-- Compassionate Section -->
<section class="compassionate-section">
    <div class="container-fluid p-100 mt-5">
        <div class="row align-items-center">
            <!-- Left Side with Image and Badge -->
            <div class="col-md-6 position-relative">
                <img src="{{ $product->getFirstMediaUrl($product_media_collection) }}" alt="Anxiety & Trauma"
                     class="book-innerpage-img" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                <span class="badge position-absolute badge-custom">{{ getColumn($product->category, 'name') }}</span>
            </div>

            <!-- Right Side with Book Details -->
            <div class="col-md-6">

                <h2 class="bookinner-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {{ __('lang.Book') }}
                </h2>
                <h2 class="bookinner-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {{ getColumn($product, 'name') }}
                </h2>
                <div class="buy-now-prices  d-flex align-items-center " data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    @if( $product->sale_price)
                        <h5 class="original-price mx-2"><span>$</span>{{ $product->price }}</h5>
                        <h5 class="discounted-price"><span>$</span>{{ $product->sale_price  }}</h5>
                    @else
                        <h5 class="discounted-price"><span>$</span>{{ $product->price  }}</h5>
                    @endif
                </div>

                <p class="buy-now-desc" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {!! getColumn($product, isset($type) && in_array($type, ['books', 'event']) ? 'description': 'short_description') !!}
                </p>

                <p class="bookinner-description" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    {!! getColumn($product, isset($type) && $type == 'books' ? 'description': 'short_description') !!}
                    <!-- ShareThis BEGIN -->
                <div class="sharethis-inline-share-buttons"></div>
                <!-- ShareThis END -->
                </p>

                <br>
                @if(auth()->check())
                <form action="{{route('checkout')}}" method="POST">
                    @csrf

                    <input hidden="" name="product_slug" value="{{$product->slug}}">
                    <input hidden="" name="product_model" value="{{get_class($product)}}">

                    <button type="submit" class="buy-now-innerbtn" data-aos="fade-up" data-aos-duration="1000"
                            data-aos-offset="10">
                        {{ __('lang.Buy Now') }}
                    </button>
                </form>
                @else
                    <a href="{{route('login.show')}}" class="buy-now-innerbtn" data-aos="fade-up" data-aos-duration="1000"
                            data-aos-offset="10">
                        {{ __('lang.Buy Now') }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</section>
<br>

@if(isset($type) && $type == 'books')


    <div class="Container-fluid p-100 mt-5">
        <div class="col-md-12">
            <div class="section-description mb-3">
                <div class="btn-desc-inner"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">{{ __('lang.Description')}}</div>
                <hr class="custom-desc-hr"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
            </div>
            <div class="description-inner-book">
                <h3 class="desc-inner-title-course mt-5"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">{{ __('lang.Description')}}</h3>
                <p class="desc-inner-paragraph-course"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">  {!! getColumn($product, 'description') !!}</p>
            </div>
        </div>
    </div>

@else
    <!-- No More Section -->
    <section class="Nomore-section">
        <div class="container-fluid p-100">
            <div class="row align-items-center">
                <div class="col-md-6 text-secbook-inner">
                    <h2 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_one_title') !!}
                    </h2>
                    <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_one_description') !!}
                    </p>
                </div>
                <div class="col-md-6">
                    <img src="{{ $product->getFirstMediaUrl($first_section_media_collection) }}" alt=""
                         class="secbook-inner-img" data-aos="fade-up"
                         data-aos-duration="1000" data-aos-offset="10">
                </div>
            </div>
        </div>
    </section>

    <!-- Discipline Section -->
    <section class="discipline-section">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Left Side with Image -->
                <div class="col-md-6">
                    <img src="{{ $product->getFirstMediaUrl($second_section_media_collection) }}" alt="Discipline"
                         class="discipline-img" data-aos="fade-up"
                         data-aos-duration="1000" data-aos-offset="10">
                </div>

                <!-- Right Side with Title, Star, and Text -->
                <div class="col-md-6 text-stars-section">
                    <h2 class="discipline-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_two_title') !!}
                    </h2>
                    <!-- Start of List Items -->
                    <div class="d-flex align-items-center text-with-star">
                        <img src="{{ asset('website/assets/images/star-icon.svg') }}" alt="Star" class="star-img"
                             data-aos="fade-up"
                             data-aos-duration="1000" data-aos-offset="10">
                        <span class="discipline-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_two_description') !!}
                    </span>
                    </div>
                    <!-- End of List Items -->
                </div>
            </div>
        </div>
    </section>

    <!-- Not Divide Section -->
    <section class="NotDivide-section">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Left Side with Title, Star, and Text -->
                <div class="col-md-6 text-stars-section">
                    <h2 class="discipline-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_three_title') !!}
                    </h2>
                    <!-- Start of List Items -->
                    <div class="d-flex align-items-center text-with-star">
                        <img src="{{ asset('website/assets/images/star-icon.svg') }}" alt="Star" class="star-img"
                             data-aos="fade-up"
                             data-aos-duration="1000" data-aos-offset="10">
                        <span class="discipline-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {!! getColumn($product, 'section_three_description') !!}
                    </span>
                    </div>
                    <!-- End of List Items -->
                </div>
                <!-- Right Side with Image -->
                <div class="col-md-6">
                    <img src="{{ $product->getFirstMediaUrl($third_section_media_collection) }}" alt="Discipline"
                         class="NotDivide-img" data-aos="fade-up"
                         data-aos-duration="1000" data-aos-offset="10">
                </div>
            </div>
        </div>
    </section>
@endif


