<section class="interested-books-section">
    <div class="container-fluid p-100">
        <h5 class="interested-books-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
            {{ __("lang.You Might be Interested in") }}
        </h5>
        <div class="row">
            <!-- Interested Product Card -->
            @foreach($interested_products as $interested_product)
                <div class="col-md-3 mb-4">
                    <div class="buy-now-card">
                        <img src="{{ $interested_product->getFirstMediaUrl($interested_product_media_collection) }}"
                             class="buy-img-card" alt="{{ getColumn($interested_product, 'name') }}"
                             data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <div class="buy-now-card-body">
                            <h5 class="buy-now-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ getColumn($interested_product, 'name') }}
                            </h5>
                            <p class="buy-now-desc" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {!! getColumn($interested_product, isset($type) && $type == 'books' ? 'description': 'short_description') !!}

                            </p>
                            <div class="buy-now-prices  d-flex align-items-center " data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                @if( $interested_product->sale_price)
                                    <h5 class="original-price mx-2"><span>$</span>{{ $interested_product->price }}</h5>
                                    <h5 class="discounted-price"><span>$</span>{{ $interested_product->sale_price  }}</h5>
                                @else
                                    <h5 class="discounted-price"><span>$</span>{{ $interested_product->price  }}</h5>
                                @endif
                            </div>
                            <a href="#" class="buy-now-btn" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.Buy Now") }}
                            </a>
                            <a href="#" class="buynow-see-details" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.See Details") }}
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
