<?php

namespace App\Services\Website\Event;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\EventRepositoryInterface;
use App\Services\BaseService;

class GetEventService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly EventRepositoryInterface $eventRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->eventRepository->get($this->dto);
    }
}
