<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Category\GetCategoryDto;
use App\DTOs\Api\Course\GetCourseDto;
use App\Enums\Category\CategoryTypes;
use App\Enums\Order\OrderStatus;
use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Services\Website\Category\GetCategoriesService;
use App\Services\Website\Courses\GetCourseBySlugService;
use App\Services\Website\Courses\GetCoursesService;
use App\Services\Website\Courses\GetInterestedCoursesService;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class CourseController extends Controller
{

    public function __construct(
        private readonly GetCoursesService    $getCoursesService,
        private readonly GetCategoriesService $getCategoriesService,
        private readonly GetCourseBySlugService      $getCourseBySlugService,
        private readonly GetInterestedCoursesService $getInterestedCoursesService,
    )
    {
    }

    public function index(Request $request): View|\Illuminate\Foundation\Application|Factory|Application
    {

        $request->merge(['paginated' => true]);

        $dto = new GetCourseDto($request->only('paginated', 'categories'));

        $courses = $this->getCoursesService->setDto($dto)->execute();

        $categoryDto = new GetCategoryDto([]);

        $categories = $this->getCategoriesService->setDto($categoryDto)->setType(CategoryTypes::COURSE->value)->execute();
        $coverDescription = Page::query()->where('slug', \App\Enums\Page\Page::COURSES_COVER_DESCRIPTION->value)->first();

        return view('website.courses', [
            "courses" => $courses,
            "categories" => $categories,
            "coverDescription" => $coverDescription,
        ]);
    }

    public function show(Request $request, string $slug): View|\Illuminate\Foundation\Application|Factory|Application
    {

        $request->merge(['limit'=> 4]);
        $dto = new GetCourseDto($request->all());
        $course = $this->getCourseBySlugService->setSlug($slug)->execute();
        $HasPurchasedCourse = auth()->check() && !!auth()->user()->orders()->where('productable_id', $course->id)->where('status', OrderStatus::PAID)->where('is_suspended', false)->count();
        $interested_courses = $this->getInterestedCoursesService->setDto($dto)->setCategoryId($course->category_id)->execute();

        return view('website.courses-show', [
            "course" => $course,
            "interested_courses" => $interested_courses,
            "HasPurchasedCourse" => $HasPurchasedCourse,
        ]);
    }

    public function showCourseVideos(Request $request, string $slug, $video_id)
    {

        $course = $this->getCourseBySlugService->setSlug($slug)->execute();
        $video = $course->videos()->where('id',$video_id )->first();
        $HasPurchasedCourse = auth()->check() && !!auth()->user()->orders()->where('productable_id', $course->id)->where('status', OrderStatus::PAID)->where('is_suspended', false)->count();


        if (!$HasPurchasedCourse){
            toast( __('You cant access this video'),'alert')->autoClose(9000);

            return redirect()->back();
        }

        return view('website.course-videos', [
            "course" => $course,
            "video" => $video,
            "HasPurchasedCourse" => $HasPurchasedCourse,
        ]);
    }
}
