<?php

namespace App\Filament\Resources;

use App\Enums\About\AboutUsTypes;
use App\Enums\Home\HomeTypes;
use App\Enums\Media\MediaCollection;
use App\Filament\Resources\HomeResource\Pages;
use App\Filament\Resources\HomeResource\RelationManagers;
use App\Models\Home;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class HomeResource extends Resource
{
    protected static ?string $model = Home::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Home';
    protected static ?string $navigationLabel = 'Home Section';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Forms\Components\Select::make('type')
                    ->options(HomeTypes::getHomeTypes())
                    ->reactive()
                    ->required(),

                Forms\Components\TextInput::make('title_ar')
                    ->label('Title (Arabic)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [HomeTypes::YOU_TUBE->value, HomeTypes::SLOGAN->value, HomeTypes::ABOUT_KYDZZO->value])) // Hide for specific types
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('title_en')
                    ->label('Title (English)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [HomeTypes::YOU_TUBE->value, HomeTypes::SLOGAN->value])) // Hide for specific types
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('description_ar')
                    ->label('Description (Arabic)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [HomeTypes::YOU_TUBE->value, HomeTypes::SLOGAN->value])) // Hide for specific types
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('description_en')
                    ->label('Description (English)')
                    ->required()
                    ->hidden(fn($get) => in_array($get('type'), [HomeTypes::YOU_TUBE->value, HomeTypes::SLOGAN->value])) // Hide for specific types
                    ->columnSpanFull(),

                Forms\Components\TextInput::make('youtube_channel_url')
                    ->required()
                    ->url()
                    ->maxLength(65535)
                    ->hidden(fn($get) => $get('type') != HomeTypes::YOU_TUBE->value)
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('youtube_video_url')
                    ->required()
                    ->maxLength(65535)
                    ->hidden(fn($get) => $get('type') != HomeTypes::YOU_TUBE->value)
                    ->columnSpanFull(),

                SpatieMediaLibraryFileUpload::make('image')
                    ->label('Image')
                    ->collection(MediaCollection::HOME->value)
                    ->hidden(fn($get) => in_array($get('type') , [HomeTypes::SLOGAN->value, HomeTypes::ABOUT_KYDZZO->value, HomeTypes::COVER->value]) )
                    ->columnSpanFull(),

                SpatieMediaLibraryFileUpload::make('english_home_slogan_image')
                    ->label('Image (English)')
                    ->collection(MediaCollection::SLOGAN_HOME_IMAGE_ENGLISH->value)
                    ->hidden(fn($get) => $get('type') != HomeTypes::SLOGAN->value)
                    ->columnSpanFull(),

                SpatieMediaLibraryFileUpload::make('arabic_home_slogan_image')
                    ->label('Image (Arabic)')
                    ->collection(MediaCollection::SLOGAN_HOME_IMAGE_ARABIC->value)
                    ->hidden(fn($get) => $get('type') != HomeTypes::SLOGAN->value)
                    ->columnSpanFull(),
                    
                                    SpatieMediaLibraryFileUpload::make('english_home_cover_image')
                    ->label('Cover (English)')
                    ->collection('home_cover_image_english')
                    ->hidden(fn($get) => $get('type') != HomeTypes::COVER->value)
                    ->columnSpanFull(),

                SpatieMediaLibraryFileUpload::make('arabic_home_cover_image')
                    ->label('Cover (Arabic)')
                    ->collection('home_cover_image_arabic')
                    ->hidden(fn($get) => $get('type') != HomeTypes::COVER->value)
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('type')
                    ->formatStateUsing(function (TextColumn $column): ?string {
                        return HomeTypes::getHomeType($column->getRecord()->type);
                    })
                    ->label('Type')
                    ->sortable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListHomes::route('/'),
            'create' => Pages\CreateHome::route('/create'),
            'edit' => Pages\EditHome::route('/{record}/edit'),
        ];
    }
    public static function canCreate(): bool
    {
        return false;
    }

    public static function canDeleteAny(): bool
    {
        return false;
    }

}
