<?php

namespace App\DTOs\Api\Event;

use App\DTOs\AbstractDTO;

class GetEventDto extends AbstractDTO
{

    private ?array $categories;
    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [];
    }

    final protected function map(array $data): bool
    {
        $this->categories = isset($data['categories']) ? $data['categories'] : null;
        return true;
    }

    /**
     * @return array|null
     */
    public function getCategories(): ?array
    {
        return $this->categories;
    }



}
